//=============================================================================
// WormHole BloodSplat.
//=============================================================================
class WHBloodSplat extends DeusExDecal;

#exec TEXTURE IMPORT NAME="WHGibSplat1" FILE="C:\DeusEx\MSTNM\Textures\WHGibSplat1.pcx" GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME="WHGibSplat2" FILE="C:\DeusEx\MSTNM\Textures\WHGibSplat2.pcx" GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME="WHGibSplat3" FILE="C:\DeusEx\MSTNM\Textures\WHGibSplat3.pcx" GROUP=Skins FLAGS=2

function BeginPlay()
{
	local Rotator rot;
	local float rnd;

	// Gore check
	if (Level.Game.bLowGore || Level.Game.bVeryLowGore)
	{
		Destroy();
		return;
	}

	rnd = FRand();
	if (rnd < 0.25)
		Texture = Texture'WHGibSplat1';
	else if (rnd < 0.5)
		Texture = Texture'WHGibSplat2';
	else if (rnd < 0.75)
		Texture = Texture'WHGibSplat3';

	DrawScale += FRand() * 0.2;

	Super.BeginPlay();
}

defaultproperties
{
     Texture=Texture'WHGibSplat2'
     DrawScale=0.200000
}
